	var xmlHttp;
	var last_time_up=0;
	var last_time_down=0;

	function createXMLHttpRequest(){
	 if(window.ActiveXObject){
	  xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
	 }
	 else if(window.XMLHttpRequest){
	  xmlHttp = new XMLHttpRequest();
	 }
	}

	function getframe(){
	 createXMLHttpRequest();
	 var url="getframe.php";
	 xmlHttp.open("POST",url,true);
	 xmlHttp.onreadystatechange = callback_getframe;
	 xmlHttp.setRequestHeader("content-type", "application/x-www-form-urlencoded");
	 xmlHttp.send("last_time_up="+last_time_up+"&last_time_down="+last_time_down);
	}


	function callback_getframe(){
	 if(xmlHttp.readyState == 4){
	  if(xmlHttp.status == 200){
		//console.log(xmlHttp.responseText);
	   var data = JSON.parse(xmlHttp.responseText);
	   if(last_time_up == 0){
	    last_time_up = data.time_up;
	   }
	   else{
	    if(last_time_up != data.time_up){
		last_time_up = data.time_up;
		console.log(data.frame_up);
	    	logread(data.frame_up["rxpk"][0]);    	
		}
	   }

	   if(last_time_down == 0){
	    last_time_down = data.time_down;
	   }
	   else{
	    if(last_time_down != data.time_down){
		last_time_down = data.time_down;
	    	 logread(data.frame_down["txpk"]); 
		}
	   }
	  }
	 }
	}
function post(url,para,Func){
	createXMLHttpRequest();
	xmlHttp.open("POST",url,true);
	xmlHttp.onreadystatechange = function(){
		if(xmlHttp.readyState === 4 && xmlHttp.status === 200){            
		//console.log(xmlHttp.responseText);
			var result=JSON.parse(xmlHttp.responseText);
			Func(result);
		}
	}
	xmlHttp.setRequestHeader("Content-type", "application/json");
	xmlHttp.send(para);
}
	Date.prototype.format = function(format) {
		var o = {
			"M+": this.getMonth() + 1, //month
			"d+": this.getDate(), //day
			"h+": this.getHours(), //hour
			"m+": this.getMinutes(), //minute
			"s+": this.getSeconds(), //second
			"q+": Math.floor((this.getMonth() + 3) / 3), //quarter
			"S": this.getMilliseconds() //millisecond
		}

		if (/(y+)/.test(format)) {
			format = format.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
		}

		for (var k in o) {
			if (new RegExp("(" + k + ")").test(format)) {
				format = format.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k] : ("00" + o[k]).substr(("" + o[k]).length));
			}
		}
		return format;
	}

	var MTYPE_JOIN_REQUEST     =     0;
	var MTYPE_JOIN_ACCEPT      =     1;
	var MTYPE_UNCONFIRM_DATA_UP=     2;
	var MTYPE_UNCONFIRM_DATA_DOWN=   3;
	var MTYPE_CONFIRM_DATA_UP  =     4;
	var MTYPE_CONFIRM_DATA_DOWN=     5;
	var MTYPE_RFU              =     6;
	var MTYPE_PROPRITARY       =     7;
	
	function pkt_type_toString(type){
		switch(type){
			case MTYPE_JOIN_REQUEST : return "Join Request";
			case MTYPE_JOIN_ACCEPT:return "Join Accept";
			case MTYPE_UNCONFIRM_DATA_UP:return "Uncomfirm data up";
			case MTYPE_UNCONFIRM_DATA_DOWN:return "Uncomfirm data down";
			case MTYPE_CONFIRM_DATA_UP:return "Confirm data up";
			case MTYPE_CONFIRM_DATA_DOWN:return "Confirm data down";
			case MTYPE_RFU:return "RFU";
			case MTYPE_PROPRITARY:return "Propritary";
			default:return "Unknown";
		}
	}
	var total = 0;
	var up = 0;
	var down = 0;

	var interval = null;
	

	function _base64ToArrayBuffer(base64){
		var binary_string =  window.atob(base64);
		var len = binary_string.length;
		var bytes = new Uint8Array( len );
		for (var i = 0; i < len; i++)        {
			bytes[i] = binary_string.charCodeAt(i);
		}
		return bytes.buffer;
	}
	var logger_idx = 0;
	function pktToggle(id){ 
		$("#" + id + "_d").toggle();
	}

	function MTypeToString(Mtype){
		switch(Mtype){
			case 0 : return "Join Request";
			case 1 : return "Join Accept";
			case 2 : return "Unconfirmed Data Up";
			case 3 : return "Unconfirmed Data Down";
			case 4 : return "Confirmed Data Up";
			case 5 : return "Confirmed Data Down";
			case 6 : return "ReJoin Request";
			case 7 : return "Proprietary";
		}
		return "";
	}
	function CRCInfo2String(info){
		var stat = info.stat;
		if(stat != undefined ){
			switch(stat){
				case 1 :return "CRC_OK";
				case -1 : return "CRC_ERR";
				case 0 : return "NO_CRC";
			}
		}
		else{
			if( info.ncrc ){
				return "NO_CRC";
			}
			else{
				return "CRC";
			}
		}
	}

	function logread(info){
		var content = $("#packet_logger_div");
				var time = new Date();
					var fType = 0;
					if( info.fType ){
						fType = info.fType;
						delete info["fType"];
					}
					total++;
					var pkt_id = "pkt_" + (logger_idx++);
					content.prepend("<div id='"+pkt_id+"' class='pkt_item' > \
						<div class='pkt_l fType_"+fType+"' id='"+pkt_id+"_l' onClick='pktToggle(\""+pkt_id+"\")' ></div>		\
						<div class='pkt_d' id='"+pkt_id+"_d'></div>		\
						</div>");
					var pkt_l = $("#" + pkt_id+"_l");
					pkt_l.append("\
						<div class='tm'>"+time.format("hh:mm:ss")+"</div>\
						<div class='freq'>"+(info.freq)+"</div>\
						<div class='rssi'></div>	\
						<div class='snr'></div>	\
						");
					pkt_l.append("<div class='stat'>"+CRCInfo2String(info)+"</div>");
					pkt_l.append("<div class='modu'>"+(info.modu?info.modu:"&nbsp;&nbsp;&nbsp;")+"</div>");
					pkt_l.append("<div class='codr'>"+(info.codr?info.codr:"&nbsp;&nbsp;&nbsp;")+"</div>");
					pkt_l.append("<div class='datr'>"+(info.datr?info.datr:"")+"</div>");
					$("#"+ pkt_id+"_d").append("<pre>" + JSON.stringify(info, null, 4)+"</pre>");

					if( info.stat && info.stat == -1 ){
						pkt_l.prepend("<div class='dir' ><i style='color:red' class='fa fa-arrow-circle-up'></i> Err Uplink</div>");
						pkt_l.children(".rssi").first().html(info.rssi);
						pkt_l.children(".snr").first().html(info.lsnr?info.lsnr:"");
					}
					else{

						var buffer = _base64ToArrayBuffer(info.data);
						var PHYPayload = new DataView(buffer);
						var MHDRObj = {};

						var MHDR = PHYPayload.getUint8(0);
						
						var MType = ( MHDR & 0xE0 ) >> 5;
						switch(MType){
							case 0:{
								pkt_l.prepend("<div class='dir' data='"+MTypeToString(MType)+"' ><i style='color:#f7d429' class='fa fa-bolt'></i>  Join Request</div>");
								pkt_l.addClass("msg_jr");
								up++;
								break;
							}
							case 1:{
								pkt_l.prepend("<div class='dir' data='"+MTypeToString(MType)+"' ><i style='color:#07ec7a' class='fa fa-bolt'></i>  Join Accept</div>");
								pkt_l.addClass("msg_ja");
								down++;
								break;
							}
							case 2:{
								pkt_l.prepend("<div class='dir' data='"+MTypeToString(MType)+"' ><i style='color:blue' class='fa fa-arrow-circle-up'></i>  Unconfirmed Up</div>");
								pkt_l.addClass("msg_ucu");
								up++;
								break;
							}
							case 3:{
								pkt_l.prepend("<div class='dir' data='"+MTypeToString(MType)+"' ><i style='color:green' class='fa fa-arrow-circle-down'></i>  Unconfirmed Down</div>");
								pkt_l.addClass("msg_cu");
								up++;
								break;
							}
							case 4:{
								pkt_l.prepend("<div class='dir' data='"+MTypeToString(MType)+"' ><i style='color:blue' class='fa fa-arrow-circle-up'></i>  Confirmed Up</div>");
								pkt_l.addClass("msg_ucd");
								down++;
								break;
							}
							case 5:{
								pkt_l.prepend("<div class='dir' data='"+MTypeToString(MType)+"' ><i style='color:green' class='fa fa-arrow-circle-down'></i>  Confirmed Down</div>");
								pkt_l.addClass("msg_cd");
								down++;
								break;
							}
							case 6:{
								pkt_l.prepend("<div class='dir' data='"+MTypeToString(MType)+"' ><i style='color:#f7d429' class='fa fa-bolt'></i>   ReJoin Request</div>");
								pkt_l.addClass("msg_jr");
								up++;
								break;
							}
						}

						

						MHDRObj.MType = MTypeToString(MType);
						MHDRObj.RFU = ( MHDR & 0x1C ) >> 2;
						MHDRObj.Major = MHDR & 0x03;

						var PHYPLObj = {
							"MHDR" : MHDRObj
						};

						switch(MType){
							case 0:{
								PHYPLObj.JoinRequest = {};
								PHYPLObj.JoinRequest.AppEUI = "";
								for(var i = 7; i >= 0; i--){
									var si = PHYPayload.getUint8(i+1).toString(16).toUpperCase();;
									if( si.length < 2 )
										si ="0" + si;
									PHYPLObj.JoinRequest.AppEUI += si + " ";
								}

								PHYPLObj.JoinRequest.DevEUI = "";
								for(var i = 7; i >= 0; i--){
									var si = PHYPayload.getUint8(i+9).toString(16).toUpperCase();
									if( si.length < 2 )
										si ="0" + si;
									PHYPLObj.JoinRequest.DevEUI += si + " ";
								}
								PHYPLObj.JoinRequest.DevNonce = PHYPayload.getUint16(17, true).toString(16).toUpperCase();
								pkt_l.append("<div class='appeui' ><span class='pkt_l_i'>AppEUI</span><span>"+PHYPLObj.JoinRequest.AppEUI+"</span></div>");
								pkt_l.append("<div class='deveui' ><span class='pkt_l_i'>DevEUI</span><span>"+PHYPLObj.JoinRequest.DevEUI+"</span></div>");
								PHYPLObj.MIC = PHYPayload.getUint32(19, true).toString(16).toUpperCase();

								pkt_l.children(".rssi").first().html(info.rssi);
								pkt_l.children(".snr").first().html(info.lsnr);
								break;
							}
							case 1:{
								var JoinAccept = "";
								var len = info.size - 1 - 4;
								for( var i = 0; i < len; i++ ){
									var oneB = PHYPayload.getUint8(i+1);
									if( oneB <= 0x0F ){
										JoinAccept += "0"+oneB.toString(16).toUpperCase();
									}
									else{
										JoinAccept += oneB.toString(16).toUpperCase();
									}
								}
								PHYPLObj.JoinAccept = JoinAccept;
								PHYPLObj.MIC = PHYPayload.getUint32(info.size - 4).toString(16).toUpperCase();
								break;
							}
							case 3:;
							case 5:;
							case 2:;
							case 4:{

								var FHDR = {};
								var MACPayload = {
									"FHDR" : FHDR
								};

								PHYPLObj.MACPayload = MACPayload;

								FHDR.DevAddr = PHYPayload.getUint32(1, true).toString(16).toUpperCase();

								while(FHDR.DevAddr.length < 8 ){
									FHDR.DevAddr = "0" + FHDR.DevAddr;
								}

								var fctrl = PHYPayload.getUint8(5);

								FHDR.FCtrl = {};
								FHDR.FCtrl.ADR = (fctrl & 0b10000000)?true:false;
								if( MType == 2 || MType == 4 ){
									FHDR.FCtrl.ADRACKReq = (fctrl & 0b01000000)?true:false;
									FHDR.FCtrl.ClassB = (fctrl & 0b00010000)?true:false;
								}
								else{
									FHDR.FCtrl.RFU = (fctrl & 0b01000000)?1:0;
									FHDR.FCtrl.FPending = (fctrl & 0b00010000)?true:false;
								}
								FHDR.FCtrl.ACK = (fctrl & 0b00100000)?true:false;
								
								FHDR.FCtrl.FOptsLen = fctrl & 0b00001111;

								FHDR.FCnt = PHYPayload.getUint16(6, true);
								/*
								if( FHDR.FCtrl.FOptsLen > 0 ){
									FHDR.FOpts = {};
									var CID = PHYPayload.getUint8(7);
									switch(CID){
										case 0x01 : {

											break;
										}
										case 0x02 :{
											var LinkCheckReq = {
												Margin : PHYPayload.getUint8(8),
												GwCnt : PHYPayload.getUint8(9)
											}
											FHDR.FOpts.LinkCheckReq = LinkCheckReq;
											break;
										}
										
										default:break;
									}
								}
								*/
								pkt_l.append("<div class='cnt' >"+FHDR.FCnt+"</div>");
								pkt_l.append("<div class='devaddr' ><span class='pkt_l_i'>DevAddr</span><span>"+FHDR.DevAddr+"</span></div>");

								if( info.size - 1 - 4 - 1 -2 - FHDR.FCtrl.FOptsLen - 4 > 0 ){
									MACPayload.FPort = PHYPayload.getUint8(8 + FHDR.FCtrl.FOptsLen);
									pkt_l.append("<div class='fport' ><span class='pkt_l_i'>FPort</span><span>"+MACPayload.FPort+"</span></div>");
									var FRMPayloadSize = info.size - 1 - 4 -1 -2-FHDR.FCtrl.FOptsLen - 4 -1;
									MACPayload.FRMPayload = "";
									for(var i = 0; i < FRMPayloadSize; i++ ){
										var byte = PHYPayload.getUint8(8 + FHDR.FCtrl.FOptsLen + i).toString(16);
										if(byte.length == 1){
											byte = "0" + byte;
										}
										MACPayload.FRMPayload += byte.toUpperCase() + " ";
									}
									pkt_l.append("<div class='payload' ><span class='pkt_l_i'>Payload</span><span>"+MACPayload.FRMPayload+"</span></div>");
								}

								PHYPLObj.MIC = PHYPayload.getUint32( info.size - 4).toString(16).toUpperCase();
								if(MType == 2 || MType == 4 ){
									pkt_l.children(".rssi").first().html(info.rssi);
									pkt_l.children(".snr").first().html(info.lsnr);
								}

								break;
							}
						}

						$("#"+ pkt_id+"_d").append("<pre>"+JSON.stringify(PHYPLObj,null,4)+"</pre>");
					}
					if( fType == 1 ){
						pkt_l.append("<div class='ftype_info'>Push into buffer</div>")
					}
					if( fType == 2 ){
						pkt_l.append("<div class='ftype_info'>Pop from buffer</div>")
					}

					pkt_filter(pkt_l);
					$("#pkt_total").html(total);
					$("#pkt_uplink").html(up);
					$("#pkt_downlink").html(down);
}

function pkt_filter(pkt){
	var ftype = $("#filter_type").val();
	var fdevaddr = $("#filter_devaddr").val();
	var fcrc = $("#filter_crc").get(0).checked;

	var isShow = true;
	switch(ftype){
		case "All" :{
			isShow = true;
			break;
		}
		case "JoinAccept" : {
			if( pkt.children('.dir').first().attr("data") == "Join Accept"){
				isShow = true;
			}
			else{
				isShow = false;
			}
			break;
		}
		case "JoinRequest" : {
			if( pkt.children('.dir').first().attr("data") == "Join Request"){
				isShow = true;
			}
			else{
				isShow = false;
			}
			break;
		}
		case "UnconfirmedUp" :{
			if( pkt.children('.dir').first().attr("data") == "Unconfirmed Data Up"){
				isShow = true;
			}
			else{
				isShow = false;
			}
			break;
		}
		case "UnconfirmedDown" :{
			if( pkt.children('.dir').first().attr("data") == "Unconfirmed Data Down"){
				isShow = true;
			}
			else{
				isShow = false;
			}
			break;
		}
		case "ConfirmedUp" :{
			
			if( pkt.children('.dir').first().attr("data") == "Confirmed Data Up"){
				isShow = true;
			}
			else{
				isShow = false;
			}
			break;
		}
		case "ConfirmedDown" :{
			if( pkt.children('.dir').first().attr("data") == "Confirmed Data Down"){
				isShow = true;
			}
			else{
				isShow = false;
			}
			break;
		}
		default:
		isShow = false;
		break
	}
	if( isShow == false ){
		pkt.hide();
		return;
	}

	if( fdevaddr != "" ){
		var addrNode = pkt.children('.devaddr').get(0);
		
		if( addrNode == undefined ){
			pkt.hide();
			return;
		}

		var addr = $(addrNode).children().get(1).innerHTML;
		if( addr != fdevaddr ){
			pkt.hide();
			return;
		}
	}

	if( fcrc && pkt.children('.stat').get(0).innerHTML == 'CRC_ERR'){
		pkt.hide();
		return;
	}

	pkt.show();
}

$(document).ready(function(){
	var interval = setInterval(getframe, 200);
	var pause = false;
	$("#bt_pause").click(function(){
		if(pause == false){
			$("#p_i").removeClass("fa fa-pause");
			$("#p_i").addClass("fa fa-play");
			$("#p_t").html("Play");
			clearInterval(interval);
			pause = true;
		}
		else{
			$("#p_i").removeClass("fa fa-play");
			$("#p_i").addClass("fa fa-pause");
			$("#p_t").html("Pause");
			interval = setInterval(getframe, 200);
			pause = false;
		}

	});
	$('#bt_clr').click(function(){
		$("#packet_logger_div").html("");
		total = 0;
		up = 0;
		down = 0;
		$("#pkt_total").html(total);
		$("#pkt_uplink").html(up);
		$("#pkt_downlink").html(down);
	});

	$("#bt_dl").click(function(){
		
		var content = "";
		var items = $(".pkt_l")
		
		for(var i = 0; i < items.length; i++ ){
			var item = $(items[i]).children();
			for(var j = 0; j < item.length; j++ ){
				if( j == 0 ){
					content += item[j].getAttribute('data');
				}
				else if( j == 7){
					content += "'" + item[j].innerHTML+"'";
				}
				else if( j >= 10 ){
					var cs = $(item[j]).children();
					if( cs.length > 1){
						content += cs[1].innerHTML;
					}
				}
				else
				{
					content += item[j].innerHTML;
				}
				
				if( j != item.length - 1){
					content += ',';
				}
			}
			content += "\r\n";
		}
		var aLink = document.createElement('a');
		var blob = new Blob([content],{type: "application/octet-stream"});


		aLink.download = "Packet_log" + new Date().format("_yyyyMMdd_hhmmss") + ".csv";
		aLink.style.display = "none";
		aLink.href = URL.createObjectURL(blob);
		document.body.appendChild(aLink);

		aLink.click();
		document.body.removeChild(aLink);
		
	});
	
	$("#filter_devaddr,#filter_crc,#filter_type").change(function(){
		var pkts = $(".pkt_l");
		$(".pkt_d").hide();
		pkts.each(function(i,v){
			pkt_filter($(v));
		});
	});
});
