<?php
$body = file_get_contents('php://input');

$body=json_decode($body,true);
switch($body["Band"])
{
  case 'EU433':
   $file_path = "conf/global_conf_EU433.json";
   break;
  case 'CN470':
   $file_path = "conf/global_conf_CN470.json";
   break;
  case 'EU868':
   $file_path = "conf/global_conf_EU868.json";
   break;
  case 'US915':
   $file_path = "conf/global_conf_US915.json";
   break;
  case 'AU915':
   $file_path = "conf/global_conf_AU915.json";
   break;
  default:
}

$myfile = fopen($file_path,"r") or die("Unable to open file!");
$str_global = fread($myfile,filesize($file_path));
fclose($myfile);
$global_conf = json_decode($str_global,true);
//echo "<pre>";
//print_r($global_conf );
$global_conf["ChannelGroup"]=intval($body["ChannelGroup"]);
$global_conf["gateway_conf"]["server_address"]=$body["server_address"];
$global_conf["gateway_conf"]["serv_port_up"]=intval($body["serv_port_up"]);
$global_conf["gateway_conf"]["serv_port_down"]=intval($body["serv_port_down"]);
$global_conf["SX1301_conf"]["radio_0"]["freq"]=$global_conf["radio0_freq_chg0"]+1600000*$global_conf["ChannelGroup"];
$global_conf["SX1301_conf"]["radio_1"]["freq"]=$global_conf["radio1_freq_chg0"]+1600000*$global_conf["ChannelGroup"];
$str_global=json_encode($global_conf,JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
//echo $str_global;

$file_path = "conf/local_conf.json";
$myfile = fopen($file_path,"r") or die("Unable to open file!");
$str_local = fread($myfile,filesize($file_path));
fclose($myfile);
$local_conf = json_decode($str_local,true);
$local_conf["gateway_conf"]["gateway_ID"]=$body["gateway_id"];
$str_local = json_encode($local_conf, JSON_PRETTY_PRINT);


$myfile = fopen("/home/debian/lora/packet_forwarder/lora_pkt_fwd/global_conf.json","w") or die("Unable to open file!");
fwrite($myfile, $str_global);
fclose($myfile);
$myfile = fopen("/home/debian/lora/packet_forwarder/lora_pkt_fwd/local_conf.json","w") or die("Unable to open file!");
fwrite($myfile, $str_local);
fclose($myfile);

$command='sudo systemctl restart lrgateway';
exec($command);

sleep(5);
if($body["server_address"]=='127.0.0.1')
{
	switch($body["Band"])
	{
	case 'EU433':
		$file_path = "conf/loraserver-eu433.toml";
		break;
	case 'CN470':
		$file_path = "conf/loraserver-cn470.toml";
		break;
	case 'EU868':
		$file_path = "conf/loraserver-eu868.toml";
		break;
	case 'US915':
		$file_path = "conf/loraserver-us915.toml";
		break;
	case 'AU915':
		$file_path = "conf/loraserver-au915.toml";
		break;
	default:
	}
	
	$loraserver_conf = read($file_path);
	if($body["Band"]=="CN470"||$body["Band"]=="US915"||$body["Band"]=="AU915"){
		$channelset="    enabled_uplink_channels=[";
		for($i=0;$i<7;$i++){
			$channelset=$channelset.($global_conf["ChannelGroup"]*8+$i).",";
		}
		$channelset=$channelset.($global_conf["ChannelGroup"]*8+7)."]\r\n";
		$loraserver_conf[9]=$channelset;
	}
	$toml="";
	for($i=0;$i<sizeof($loraserver_conf);$i++){
		$toml=$toml.$loraserver_conf[$i];
	}
	
	$myfile = fopen("/etc/loraserver/loraserver.toml","w") or die("Unable to open file!");
	fwrite($myfile, $toml);
	fclose($myfile);
	$command='sudo systemctl restart loraserver';
	exec($command);
}

require("getstatus.php");

function read($path){
	$file = fopen($path, "r");
	$user=array();
	$i=0;
	while(!feof($file))
	{
		$user[$i]= fgets($file);//fgets
		$i++;
	}
	fclose($file);
	$user=array_filter($user);	
	return $user;
}
?>


