#!/bin/sh
dir="/var/www/html/conf"
region=$1
subband=$2
addr=$3
portup=$4
portdown=$5
freq1=$6
freq2=$7
cp $dir/global_conf_$region.json $dir/global_conf.json

if [ "$region" = "CN470" ]
then
o_band="\"subband\":10,"
elif [ "$region" = "US915" ] || [ "$region" = "AU915" ]
then
o_band="\"subband\":1,"
fi

if [ "$region" = "CN470" ] || [ "$region" = "CN433" ]
then
        cp /root/basicstation/examples/corecell/lns-ttn/station-LF.conf /root/basicstation/examples/corecell/lns-ttn/station.conf
else
        cp /root/basicstation/examples/corecell/lns-ttn/station-HF.conf /root/basicstation/examples/corecell/lns-ttn/station.conf
fi

if [ "$region" = "CN470" ] || [ "$region" = "US915" ] || [ "$region" = "AU915" ]
then
n_band="\"subband\":$subband,"

o_freq1=$(cat $dir/global_conf.json|grep freq|head -1)
o_freq2=$(cat $dir/global_conf.json|grep freq|tail -1)
n_freq1="\"freq\": $freq1,"
n_freq2="\"freq\": $freq2,"
sed -i "s/${o_band}/${n_band}/g" $dir/global_conf.json
sed -i "s/${o_freq1}/${n_freq1}/g" $dir/global_conf.json
sed -i "s/${o_freq2}/${n_freq2}/g" $dir/global_conf.json
fi


o_addr="\"server_address\": \"127.0.0.1\","
n_addr="\"server_address\": \"$addr\","

n_portup="\"serv_port_up\": $portup,"
o_portup="\"serv_port_up\": 1700,"

n_portdown="\"serv_port_down\": $portdown,"
o_portdown="\"serv_port_down\": 1700,"

sed -i "s/${o_addr}/${n_addr}/g" $dir/global_conf.json
sed -i "s/${o_portup}/${n_portup}/g" $dir/global_conf.json
sed -i "s/${o_portdown}/${n_portdown}/g" $dir/global_conf.json

cp  $dir/global_conf.json /root/lora/packet_forwarder/lora_pkt_fwd/global_conf.json
echo "pkt" > /root/.func/gatewaymode
sync
systemctl restart lrgateway
sync
