#!/bin/bash

server_addr=$(cat /root/lora/packet_forwarder/lora_pkt_fwd/global_conf.json | grep "server_address"| awk -F'"' '{print $4}')
port_up=$(cat /root/lora/packet_forwarder/lora_pkt_fwd/global_conf.json | grep "serv_port_up"| awk -F':' '{print $2}'|awk -F, '{print $1}'|awk -F' ' '{print $1}')
port_down=$(cat /root/lora/packet_forwarder/lora_pkt_fwd/global_conf.json | grep "serv_port_down"| awk -F':' '{print $2}'|awk -F, '{print $1}'|awk -F' ' '{print $1}')
extra_server=$(cat /root/lora/packet_forwarder/lora_pkt_fwd/server_conf.json | grep "enable"| awk -F':' '{print $2}'|awk -F, '{print $1}'|awk -F' ' '{print $1}')
server_addr1=$(cat /root/lora/packet_forwarder/lora_pkt_fwd/server_conf.json | grep "server_address"| awk -F'"' '{print $4}')
port_up1=$(cat /root/lora/packet_forwarder/lora_pkt_fwd/server_conf.json | grep "serv_port_up"| awk -F':' '{print $2}'|awk -F, '{print $1}'|awk -F' ' '{print $1}')
port_down1=$(cat /root/lora/packet_forwarder/lora_pkt_fwd/server_conf.json | grep "serv_port_down"| awk -F':' '{print $2}'|awk -F, '{print $1}'|awk -F' ' '{print $1}')


eth=$(ifconfig eth0 | grep ether |  awk '{print $2}')
disk_G=$(df -h | grep root | awk '{print $3}'| awk -F\"G\" '{print $1}')
disk_p=$(df -h | grep root | awk '{print $5}'| awk -F\"%\" '{print $1}')
logsize=$(du -sh /var/log|awk -F' ' '{print $1}')
tmp=$(free -m | grep Mem | awk '{print $7}')
mem_p=$(echo "scale=2;100-$tmp/2048*100"|bc)
mem=$(echo "scale=1;3-$tmp/1000"|bc)
temperature=$(cat /sys/devices/virtual/thermal/thermal_zone0/temp)
temperature=${temperature:0:2}
region=$(cat /root/lora/packet_forwarder/lora_pkt_fwd/global_conf.json | grep "region"| awk -F'"' '{print $4}')
subband=$(cat /root/lora/packet_forwarder/lora_pkt_fwd/global_conf.json | grep "subband"| awk -F':' '{print $2}'|awk -F, '{print $1}')
gwid=$(cat /root/lora/packet_forwarder/lora_pkt_fwd/gwid)
apssid=$(cat /etc/hostapd/hostapd.conf|grep ssid|awk -F'=' '{print $2}')
logname=$(cat /etc/apache2/apache2.conf |grep "Require user"|awk -F' ' '{print $3}')
status_4g=$(cat /root/.func/setting_4g)
netmode=$(cat /root/.func/netmode)
wifi_ssid=$(cat /etc/wpa_supplicant/wpa_supplicant.conf|grep ssid|awk -F'"' '{print $2}')
wifi_pass=$(cat /etc/wpa_supplicant/wpa_supplicant.conf|grep psk|awk -F'"' '{print $2}')
have_4g=$(cat /root/.func/config|grep 4G)
have_wifi=$(cat /root/.func/config|grep WIFI)
ip_static=$(cat /etc/network/interfaces|grep static)
if [ "$ip_static" != "" ]
then
	ip_mode="static"
	ip0=$(cat /etc/network/interfaces|grep address|awk '{print $2}'|awk -F. '{print $1}')
	ip1=$(cat /etc/network/interfaces|grep address|awk '{print $2}'|awk -F. '{print $2}')
	ip2=$(cat /etc/network/interfaces|grep address|awk '{print $2}'|awk -F. '{print $3}')
	ip3=$(cat /etc/network/interfaces|grep address|awk '{print $2}'|awk -F. '{print $4}')
	mask0=$(cat /etc/network/interfaces|grep netmask|awk '{print $2}'|awk -F. '{print $1}')
        mask1=$(cat /etc/network/interfaces|grep netmask|awk '{print $2}'|awk -F. '{print $2}')
        mask2=$(cat /etc/network/interfaces|grep netmask|awk '{print $2}'|awk -F. '{print $3}')
        mask3=$(cat /etc/network/interfaces|grep netmask|awk '{print $2}'|awk -F. '{print $4}')
        gate0=$(cat /etc/network/interfaces|grep gateway|awk '{print $2}'|awk -F. '{print $1}')
        gate1=$(cat /etc/network/interfaces|grep gateway|awk '{print $2}'|awk -F. '{print $2}')
        gate2=$(cat /etc/network/interfaces|grep gateway|awk '{print $2}'|awk -F. '{print $3}')
        gate3=$(cat /etc/network/interfaces|grep gateway|awk '{print $2}'|awk -F. '{print $4}')
else
	ip_mode="dhcp"
fi

if [ "$have_4g" = "" ]
then
	have_4g="0"
else
	have_4g="1"
fi 


if [ "$have_wifi" = "" ]
then
        have_wifi="0"
else
        have_wifi="1"
fi

eth_ip=$(ifconfig eth0|grep netmask|head -1|awk -F' ' '{print $2}')

if [ "$have_wifi" = "1" ]
then
wlan_ip=$(ifconfig wlan0|grep netmask|head -1|awk -F' ' '{print $2}')
wlan=$(ifconfig wlan0 | grep ether |  awk '{print $2}')
else
wlan_ip="no wifi module"
wlan="no wifi module"
fi
if [ "$have_4g" = "1" ]
then 
ip_4g=$(ifconfig usb0|grep netmask|head -1|awk -F' ' '{print $2}')
mac_4g=$(ifconfig usb0 | grep ether |  awk '{print $2}')
else
ip_4g="no 4G module"
mac_4g="no 4G module"
fi

gatewaymode=$(cat /root/.func/gatewaymode)
basic_url=$(cat /root/basicstation/examples/corecell/lns-ttn/server_url)
basic_port=$(cat /root/basicstation/examples/corecell/lns-ttn/port)
basic_key=$(cat /root/basicstation/examples/corecell/lns-ttn/token|awk -F'Authorization: Bearer ' '{print $2}')
trust_mode=$(cat /root/.func/trust_mode)
basic_type=$(cat /root/.func/basic_type)
remote_enable=$(cat /root/.func/remotesetting|grep enable|awk -F':' '{print $2}')
remote_username=$(cat /root/.func/remotesetting|grep username|awk -F':' '{print $2}')
remote_password=$(cat /root/.func/remotesetting|grep password|awk -F':' '{print $2}')
echo -n {
echo -n \"basic_type\":\"$basic_type\",
echo -n \"basic_key\":\"$basic_key\",
echo -n \"trust_mode\":\"$trust_mode\",
echo -n \"gatewaymode\":\"$gatewaymode\",
echo -n \"basic_url\":\"$basic_url\",
echo -n \"basic_port\":\"$basic_port\",
echo -n \"status_4g\":\"$status_4g\",
echo -n \"wifi_ssid\":\"$wifi_ssid\",
echo -n \"wifi_pass\":\"$wifi_pass\",
echo -n \"netmode\":\"$netmode\",
echo -n \"apssid\":\"$apssid\",
echo -n \"mac_4g\":\"$mac_4g\",
echo -n \"eth\":\"$eth\",
echo -n \"wlan\":\"$wlan\",
echo -n \"ethip\":\"$eth_ip\",
echo -n \"ip_mode\":\"$ip_mode\",
echo -n \"remote_enable\":\"$remote_enable\",
echo -n \"remote_username\":\"$remote_username\",
echo -n \"remote_password\":\"$remote_password\",
if [ "$ip_mode" = "static" ]
then
echo -n \"ip0\":\"$ip0\",
echo -n \"ip1\":\"$ip1\",
echo -n \"ip2\":\"$ip2\",
echo -n \"ip3\":\"$ip3\",
echo -n \"mask0\":\"$mask0\",
echo -n \"mask1\":\"$mask1\",
echo -n \"mask2\":\"$mask2\",
echo -n \"mask3\":\"$mask3\",
echo -n \"gate0\":\"$gate0\",
echo -n \"gate1\":\"$gate1\",
echo -n \"gate2\":\"$gate2\",
echo -n \"gate3\":\"$gate3\",
fi

echo -n \"wlanip\":\"$wlan_ip\",
echo -n \"ip_4g\":\"$ip_4g\",
echo -n \"have_4g\":\"$have_4g\",
echo -n \"have_wifi\":\"$have_wifi\",
echo -n \"logname\":\"$logname\",
echo -n \"eth\":\"$eth\",
echo -n \"wlan\":\"$wlan\",
echo -n \"disk_G\":\"$disk_G\",
echo -n \"disk_p\":\"$disk_p\",
echo -n \"logsize\":\"$logsize\",
echo -n \"mem_p\":$mem_p,
echo -n \"mem\":$mem,
echo -n \"temperature\":\"$temperature\",
echo -n \"region\":\"$region\",
echo -n \"port_up\":\"$port_up\",
echo -n \"port_down\":\"$port_down\",
echo -n \"server_addr\":\"$server_addr\",
echo -n \"extra_server\":\"$extra_server\",
echo -n \"port_up1\":\"$port_up1\",
echo -n \"port_down1\":\"$port_down1\",
echo -n \"server_addr1\":\"$server_addr1\",
echo -n \"subband\":$subband,
echo -n \"gwid\":\"$gwid\"
echo -n }
